unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DBGrids, DB, Menus, IniFiles, ExtCtrls,
  DBTables, DBViewer, Buttons, ComCtrls;

type
  TFMain = class(TForm)
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Database1: TDatabase;
    Panel1: TPanel;
    PopupMenu1: TPopupMenu;
    DBViewer1: TDBViewer;
    QueryInit: TQuery;
    ImageList1: TImageList;
    Splitter1: TSplitter;
    Label2: TLabel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    CBxPrimary: TCheckBox;
    CBxForeign: TCheckBox;
    CBxPrefiltered: TCheckBox;
    CBxShowSQL: TCheckBox;
    CBxSelection: TCheckBox;
    CBxShowTree: TCheckBox;
    BatchMove1: TBatchMove;
    TExport: TTable;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    Exit1: TMenuItem;
    About1: TMenuItem;
    Help1: TMenuItem;
    ShowHints1: TMenuItem;
    Memo1: TMemo;
    Utilities1: TMenuItem;
    Export1: TMenuItem;
    ReadStructure1: TMenuItem;
    CBxOuter: TCheckBox;
    BDEAdmin1: TMenuItem;
    CBxLock: TCheckBox;
    Register1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CBxPrimaryClick(Sender: TObject);
    procedure CBxForeignClick(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure CBxShowSQLClick(Sender: TObject);
    procedure DBViewer1AfterOpen(DataSet: TDataSet);
    procedure SetKeyColors;
    procedure DBGrid1CellClick(Column: TColumn);
    procedure CBxPrefilteredClick(Sender: TObject);
    procedure DBViewer1Prefiltering(Sender: TObject);
    procedure CBxSelectionClick(Sender: TObject);
    procedure CBxShowTreeClick(Sender: TObject);
    procedure DBViewer1SetSelection(Sender: TObject);
    procedure DBViewer1SetOuterJoin(Sender: TObject);
    procedure DBViewer1SetShowTree(Sender: TObject);
    procedure DBViewer1CloseTree(Sender: TObject;
      var Action: TCloseAction);
    procedure Exit1Click(Sender: TObject);
    procedure Export1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure DBViewer1TreeLabelClick(FieldIndex: Smallint);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ShowHints1Click(Sender: TObject);
    procedure Read1Click(Sender: TObject);
    procedure CBxOuterClick(Sender: TObject);
    procedure DBViewer1ChangeTableName(Sender: TObject);
    procedure DBViewer1ChangeNodeState(Sender: TObject);
    procedure DBViewer1ChangeFieldState(FieldIndex: Smallint;
      visible: Boolean);
    procedure BDEAdmin1Click(Sender: TObject);
    procedure DBViewer1SetPrefiltered(Sender: TObject);
    procedure DBViewer1SetShowForeign(Sender: TObject);
    procedure DBViewer1SetShowPrimary(Sender: TObject);
    procedure DBViewer1SetShowSQL(Sender: TObject);
    procedure CBxLockClick(Sender: TObject);
    procedure DBViewer1SetTreeLock(Sender: TObject);
    procedure Register1Click(Sender: TObject);
  private
    { Private declarations }
    IsCtrlKeyDown: Boolean;
  public
    { Public declarations }
  end;

var
  FMain: TFMain;

implementation

uses dbCtrls, bde, shellApi, Registry;

var
  DllPath:string;

{$R *.DFM}

procedure TFMain.SetKeyColors;
var
  i:integer;
begin
  DBViewer1.disableControls;
  // show key fields in special colors if boxes are checked
  if (DBViewer1.showForeignKeyFields) then
    // verify that some column exists
    if DBGrid1.columns.items[0].field<>nil then
    begin
      for i:=0 to DBGrid1.columns.count-1 do
      begin
        if DBViewer1.ForeignKeyFields.indexOf(DBGrid1.columns[i].Field.DisplayLabel)<>-1 then
          DBGrid1.columns.items[i].color:=clYellow;
      end;
      DBGrid1.selectedIndex:=0;
    end;
  if (DBViewer1.showPrimaryKeyFields) then
  begin
    // verify that some column exists
    if DBGrid1.columns.items[0].field<>nil then
    begin
      for i:=0 to DBGrid1.columns.count-1 do
      begin
        if DBViewer1.primaryKeyFields.indexOf(DBGrid1.columns[i].Field.FieldName)<>-1 then
          DBGrid1.columns.items[i].color:=clAqua;
      end;
      DBGrid1.selectedIndex:=0;
    end;
  end;
  DBViewer1.enableControls;
end;

{
procedure TFMain.SetKeyColors;
var
  i:integer;
begin
  // show key fields in special colors if boxes are checked
  if (DBViewer1.showForeignKeyFields) then
    // verify that some column exists
    if DBGrid1.columns.items[0].field<>nil then
    begin
      for i:=0 to DBGrid1.columns.count-1 do
      begin
        if (DBViewer1.ForeignKeyFields.indexOf(DBViewer1.FieldLabels[DBGrid1.columns.items[i].field.fieldNo-1])<>-1) then
          DBGrid1.columns.items[i].color:=clYellow;
      end;
      DBGrid1.selectedIndex:=0;
    end;
  if (DBViewer1.showPrimaryKeyFields) then
  begin
    for i:=0 to DBGrid1.columns.count-1 do
      if (DBViewer1.primaryKeyFields.indexOf(DBGrid1.columns.items[i].fieldName)<>-1) then
        DBGrid1.columns.items[i].color:=clAqua;
    DBGrid1.selectedIndex:=0;
  end;
end;
}
procedure TFMain.FormCreate(Sender: TObject);
var
  Regist:TRegistry;
begin
  shortDateFormat:='dd/mm/yyyy';
  Session.GetAliasNames(ComboBox2.items);
  DBGrid1.Hint:='Double-Click : Sort a column'+#10+#13+
                'Ctrl-Double-Click : Sort more columns (Asc/Desc)'+#10+#13+
                'Right-Click  : Modify / Navigate'+#10+#13+
                'Memo and Graphic Fields : Click to view content';
  CBxPrimary.checked:=DBViewer1.showPrimaryKeyFields;
  CBxForeign.checked:=DBViewer1.showForeignKeyFields;
  CBxShowSQL.checked:=DBViewer1.ShowSQL;
  CBxPrefiltered.checked:=DBViewer1.Prefiltered;
  CBxSelection.checked:=DBViewer1.Selection;
  CBxShowTree.checked:=DBViewer1.ShowTree;
  CBxOuter.checked:=DBViewer1.OuterJoin;
  IsCtrlKeyDown:=False;
  ShowHints1.Checked:=ShowHint;

  // read BDE DLL path
  Regist:=TRegistry.create;
  try
    regist.RootKey:=HKEY_LOCAL_MACHINE;
    Regist.OpenKey('SOFTWARE\Borland\Database Engine',False);
    DllPath:=Regist.ReadString('DLLPATH');
  finally
    Regist.free;
  end;
end;

procedure TFMain.ComboBox1Change(Sender: TObject);
begin
  if ComboBox1.text='' then exit;
  DBViewer1.close;
  DBViewer1.tableName:=ComboBox1.text;
  if DBViewer1.Selection then
    DBViewer1.preOpen
  else
    DBViewer1.open;
end;

procedure TFMain.CBxPrimaryClick(Sender: TObject);
begin
  DBViewer1.showPrimaryKeyFields:=CBxPrimary.checked;
  SetKeyColors;
end;

procedure TFMain.CBxForeignClick(Sender: TObject);
begin
  DBViewer1.showForeignKeyFields:=CBxForeign.checked;
  SetKeyColors;
end;

procedure TFMain.ComboBox2Change(Sender: TObject);
var
  lpLCData:PChar;
begin
  dataBase1.connected:=false;
  dataBase1.AliasName:=ComboBox2.text;
  dataBase1.connected:=true;
  if not dataBase1.connected then exit;
  if (session.GetAliasDriverName(DataBase1.DatabaseName)='ORACLE') then
  // here you have to choose your national preferences for ORACLE databases
  begin
    lpLCData:=allocMem(5);
    try
      GetLocaleInfo(LOCALE_USER_DEFAULT,LOCALE_ILANGUAGE,lpLCData,5);
      if lpLCData='040c' then
      begin
        QueryInit.SQL.Text := 'ALTER SESSION SET NLS_TERRITORY = ''FRANCE''';
        QueryInit.ExecSQL;
        QueryInit.SQL.Text := 'ALTER SESSION SET NLS_LANGUAGE = ''FRENCH''';
        QueryInit.ExecSQL;
        QueryInit.SQL.Text := 'ALTER SESSION SET NLS_DATE_FORMAT = ''DD/MM/YYYY''';
        QueryInit.ExecSQL;
      end;
    finally
      freeMem(lpLCData);
    end;
  end;
  Session.GetTableNames(dataBase1.dataBaseName,'*.*',true,false,ComboBox1.items);
  ComboBox1.text:='';
end;

procedure TFMain.DBGrid1DblClick(Sender: TObject);
var
  FieldIndex:smallint;
begin
  if not DBViewer1.active then exit;
  FieldIndex:=(Sender as TDBGrid).selectedindex;
  if ((Sender as TDBGrid).selectedField.DataType in
    [ftMemo,ftBlob,ftGraphic,ftFmtMemo,ftParadoxOle, ftDBaseOle, ftTypedBinary, ftCursor])
     then exit; // non sortable data types
  if not IsCtrlKeyDown then
    DBViewer1.orderFields.clear;
  // reverse order if order is already on this field
  if (DBViewer1.OrderFields.count>0) and (DBViewer1.OrderFields.indexOf(DBViewer1.FieldLabels[DBGrid1.selectedField.FieldNo-1])<>-1) then
    DBViewer1.OrderDesc:=not DBViewer1.OrderDesc
  else
    DBViewer1.orderFields.add(DBViewer1.FieldLabels[DBGrid1.selectedField.FieldNo-1]);
  DBViewer1.RefreshView;
  (Sender as TDBGrid).selectedIndex:=FieldIndex;
end;

procedure TFMain.CBxShowSQLClick(Sender: TObject);
begin
  DBViewer1.ShowSQL:=(Sender as TCheckBox).checked;
end;

procedure TFMain.DBViewer1AfterOpen(DataSet: TDataSet);
begin
  SetKeyColors;
  Memo1.lines.assign(DBViewer1.Trace);
end;

procedure TFMain.DBGrid1CellClick(Column: TColumn);
begin
  DBViewer1.EditField(Column.Field);
end;

procedure TFMain.CBxPrefilteredClick(Sender: TObject);
begin
  DBViewer1.Prefiltered:=(Sender as TCheckBox).Checked;
end;

procedure TFMain.DBViewer1Prefiltering(Sender: TObject);
begin
  Memo1.lines.assign(DBViewer1.Trace);
end;

procedure TFMain.CBxSelectionClick(Sender: TObject);
begin
  DBViewer1.Selection:=(Sender as TCheckBox).Checked;
end;

procedure TFMain.CBxShowTreeClick(Sender: TObject);
begin
  DBViewer1.ShowTree:=(Sender as TCheckBox).checked;
end;

procedure TFMain.DBViewer1SetSelection(Sender: TObject);
begin
  CBxSelection.checked:=DBViewer1.Selection;
end;

procedure TFMain.DBViewer1SetOuterJoin(Sender: TObject);
begin
  CBxOuter.checked:=DBViewer1.OuterJoin;
end;

procedure TFMain.DBViewer1SetShowTree(Sender: TObject);
begin
  CBxShowTree.checked:=DBViewer1.ShowTree;
end;

procedure TFMain.DBViewer1CloseTree(Sender: TObject;
  var Action: TCloseAction);
begin
  CBxShowTree.Checked:=DBViewer1.ShowTree;
end;

procedure TFMain.Exit1Click(Sender: TObject);
begin
  close;
end;

procedure TFMain.Export1Click(Sender: TObject);
var
  posit:shortInt;
  i:integer;
begin
  if (not DBViewer1.active) or (DBViewer1.isEmpty) then
  begin
    ShowMessage('Nothing to do !');
    exit;
  end;
  posit:=pos('.',DBViewer1.tableName);
  if posit<>0 then
    SaveDialog1.FileName:=copy(DBViewer1.tableName,1,posit-1)+'.txt'
  else
    SaveDialog1.FileName:=DBViewer1.tableName+'.txt';
  if not SaveDialog1.execute then exit;
  TExport.tableName:=SaveDialog1.FileName;

  BatchMove1.mappings.clear;
  for i:=0 to DBViewer1.FieldCount-1 do
    if not(DBViewer1.Fields[i].DataType in
      [ftMemo,ftBlob,ftGraphic,ftFmtMemo,ftParadoxOle, ftDBaseOle, ftTypedBinary, ftCursor]) and
       (DBViewer1.Fields[i].visible) then
      BatchMove1.mappings.add(DBViewer1.Fields[i].FieldName);
  BatchMove1.execute;
end;

procedure TFMain.About1Click(Sender: TObject);
begin
  ShowMessage('Demo of DBViewer version '+DBViewer1.version);
end;

procedure TFMain.DBViewer1TreeLabelClick(FieldIndex: Smallint);
begin
  DBGrid1.SelectedField:=DBViewer1.Fields[FieldIndex];
  DBGrid1.SetFocus;
end;

procedure TFMain.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_CONTROL then
    IsCtrlKeyDown:=True;
end;

procedure TFMain.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_CONTROL then
    IsCtrlKeyDown:=False;
end;

procedure TFMain.ShowHints1Click(Sender: TObject);
begin
  (Sender as TMenuItem).Checked:=not (Sender as TMenuItem).Checked;
  FMain.ShowHint:=(Sender as TMenuItem).Checked;
  DBViewer1.ShowHint:=FMain.ShowHint;
end;

procedure TFMain.Read1Click(Sender: TObject);
begin
  DBViewer1.ForceReadStructure;
end;

procedure TFMain.CBxOuterClick(Sender: TObject);
begin
  DBViewer1.OuterJoin:=(Sender as TCheckBox).Checked;
  if (DBViewer1.tableName<>'') and (DBViewer1.active) then
  begin
    DBViewer1.close;
    DBViewer1.open;
  end;
end;

procedure TFMain.DBViewer1ChangeTableName(Sender: TObject);
begin
  ComboBox1.itemIndex:=ComboBox1.items.indexOf(DBViewer1.TableName);
end;

procedure TFMain.DBViewer1ChangeNodeState(Sender: TObject);
begin
  SetKeyColors;
end;

procedure TFMain.DBViewer1ChangeFieldState(FieldIndex: Smallint;
  visible: Boolean);
begin
  if not DBViewer1.active then exit;
  if FieldIndex=-1 then exit;
  if visible then
  begin
    if (DBViewer1.ForeignKeyFields.indexOf(DBViewer1.Fields[FieldIndex].DisplayLabel)<>-1) or
       (DBViewer1.PrimaryKeyFields.indexOf(DBViewer1.Fields[FieldIndex].FieldName)<>-1) then
      SetKeyColors;
    DBGrid1.SelectedField:=DBViewer1.Fields[FieldIndex];
    DBGrid1.SetFocus;
  end;
end;

procedure TFMain.BDEAdmin1Click(Sender: TObject);
var
  p:smallInt;
begin
  p:=pos(';',DllPath);
  if p<>0 then
    DllPath:=copy(DllPath,1,p-1);
  ShellExecute(Application.MainForm.Handle, nil,PChar(DllPath+'\BDEadmin.exe'),nil,nil,SW_SHOW);
end;

procedure TFMain.DBViewer1SetPrefiltered(Sender: TObject);
begin
  CBxPrefiltered.checked:=DBViewer1.Prefiltered;
end;

procedure TFMain.DBViewer1SetShowForeign(Sender: TObject);
begin
  CBxForeign.checked:=DBViewer1.ShowForeignKeyFields;
end;

procedure TFMain.DBViewer1SetShowPrimary(Sender: TObject);
begin
  CBxPrimary.checked:=DBViewer1.ShowPrimaryKeyFields;
end;

procedure TFMain.DBViewer1SetShowSQL(Sender: TObject);
begin
  CBxShowSQL.checked:=DBViewer1.ShowSQL;
end;

procedure TFMain.CBxLockClick(Sender: TObject);
begin
  DBViewer1.TreeLocked:=(Sender as TCheckBox).checked;
end;

procedure TFMain.DBViewer1SetTreeLock(Sender: TObject);
begin
  CBxLock.checked:=DBViewer1.TreeLocked;
end;

procedure TFMain.Register1Click(Sender: TObject);
begin
  DBViewer1.Registration;
end;

end.
